#import <UIKit/UIKit.h>
#import <UserNotifications/UserNotifications.h>

extern "C" void OpeniOSNotificationSettings() {
    if (@available(iOS 16.0, *)) {
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:UIApplicationOpenNotificationSettingsURLString] options:@{} completionHandler:nil];
    } else {
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:@"App-Prefs:root=NOTIFICATIONS_ID"] options:@{} completionHandler:nil];
    }
}

extern "C" void CheckPushPermissionStatus() {
    [[UNUserNotificationCenter currentNotificationCenter]
        getNotificationSettingsWithCompletionHandler:^(UNNotificationSettings * _Nonnull settings) {
            NSString* result = @"denied";

            if (settings.authorizationStatus == UNAuthorizationStatusAuthorized ||
                settings.authorizationStatus == UNAuthorizationStatusProvisional) {
                result = @"authorized";
            }

            UnitySendMessage("NotificationBridge", "OnPushPermissionChecked", [result UTF8String]);
        }];
}